uniform mat4 v_mvpMatrix;
uniform vec3 v_lightPos;
uniform vec3 v_eyePos;

attribute vec3 v_position;
attribute vec4 v_color;
attribute vec2 v_texCoord;

varying vec3 p_lightVec; 
varying vec3 p_halfVec;

varying vec4 p_color;
varying vec2 p_textureCoord;

void main()
{
    vec4 read_pos;
    read_pos.xyz = v_position;
    read_pos.a = 1.0;
    gl_Position = v_mvpMatrix * read_pos;
    p_color = v_color;
    p_textureCoord = v_texCoord;
    
    p_lightVec = normalize(v_lightPos - v_position);
    p_halfVec = normalize( normalize(v_eyePos - v_position.xyz) + p_lightVec);
}

